# 删除排序链表中的重复元素 II
<p>存在一个按升序排列的链表，给你这个链表的头节点 <code>head</code> ，请你删除链表中所有存在数字重复情况的节点，只保留原始链表中 <strong>没有重复出现</strong><em> </em>的数字。</p><p>返回同样按升序排列的结果链表。</p><p> </p><p><strong>示例 1：</strong></p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0082.Remove%20Duplicates%20from%20Sorted%20List%20II/images/linkedlist1.jpg" style="width: 500px; height: 142px;" /><pre><strong>输入：</strong>head = [1,2,3,3,4,4,5]<strong><br />输出：</strong>[1,2,5]</pre><p><strong>示例 2：</strong></p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0082.Remove%20Duplicates%20from%20Sorted%20List%20II/images/linkedlist2.jpg" style="width: 500px; height: 205px;" /><pre><strong>输入：</strong>head = [1,1,1,2,3]<strong><br />输出：</strong>[2,3]</pre><p> </p><p><strong>提示：</strong></p><ul>	<li>链表中节点数目在范围 <code>[0, 300]</code> 内</li>	<li><code>-100 <= Node.val <= 100</code></li>	<li>题目数据保证链表已经按升序排列</li></ul>
<p>以下错误的选项是？</p>
## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;

struct ListNode
{
    int val;
    ListNode *next;
    ListNode(int x) : val(x), next(NULL) {}
};
```
### after
```cpp

```

## 答案
```cpp
class Solution
{
public:
    ListNode *deleteDuplicates(ListNode *head)
    {
        if (!head || !head->next)
            return head;
        auto dummy = new ListNode(-1);
        dummy->next = head;
        auto pre = dummy, cur = head;
        while (cur && cur->next)
        {
            if (cur->val != cur->next->val)
            {
                pre = cur;
                cur = cur->next;
            }
            else
            {
                while (cur->next && cur->val == cur->next->val)
                {
                    cur = cur->next;
                }
            }
        }
        return dummy->next;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    ListNode *deleteDuplicates(ListNode *head)
    {
        if (!head || !head->next)
            return head;
        if (head->val == head->next->val)
        {
            while (head->next && head->val == head->next->val)
            {
                head = head->next;
            }
            return deleteDuplicates(head->next);
        }
        else
            head->next = deleteDuplicates(head->next);
        return head;
    }
};
```

### B
```cpp
class Solution
{
public:
    ListNode *deleteDuplicates(ListNode *head)
    {
        ListNode *new_head = new ListNode(0);
        ListNode *cur = new_head;
        ListNode *temp1 = head;
        while (temp1)
        {
            ListNode *temp2 = temp1->next;
            if (!temp2)
            {
                cur->next = temp1;
                temp1 = temp1->next;
                cur = cur->next;
            }
            else if (temp2 && temp1->val != temp2->val)
            {
                cur->next = temp1;
                temp1 = temp1->next;
                cur = cur->next;
            }
            else
            {
                while (temp2 && temp1->val == temp2->val)
                {
                    temp2 = temp2->next;
                }
                temp1 = temp2;
            }
        }
        cur->next = NULL;
        return new_head->next;
    }
};
```

### C
```cpp
class Solution
{
public:
    ListNode *deleteDuplicates(ListNode *head)
    {
        if (head == NULL || head->next == NULL)
            return head;
        ListNode *L = new ListNode(0);
        L->next = head;

        ListNode *slow = L;
        while (slow->next)
        {
            ListNode *fast = slow->next;
            while (fast->next && fast->val == fast->next->val)
            {
                fast = fast->next;
            }
            if (slow->next == fast)
                slow = slow->next;
            else
            {
                slow->next = fast->next;
            }
        }
        return L->next;
    }
};
```
